unit Unit1;

//      
//   Canvas    TForm, TLabel, TImage.
//     TextOut  
//     Canvas.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    LabelTitle: TLabel;
    Timer1: TTimer;
    Panel1: TPanel;
    LabelTest: TLabel;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure LabelTestMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClick(Sender: TObject);
  private
    { Private declarations }
    Index : Integer;
    ClF   : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//      TextOut
//  TCanvas,      
// (    TruType -  )
procedure CanvasSetAngle(RqCanvas : TCanvas;
                         RqAngle  : Single;
                         RqSize   : integer;
                         RqName   : String);
var
  LF   : TLOGFONT;  //  font -  Windows
  Ind  : integer;
begin
  //    LF
  FillChar(LF, SizeOf(LF), #0);
  //   () 
  LF.lfHeight := RqSize;
  //    ( )
  // LF.lfItalic := 1;
  // LF.lfUnderline := 1;
  // LF.lfStrikeOut := 1;
  //      (   )
  LF.lfEscapement  := Trunc(RqAngle * 10);
  LF.lfOrientation := Trunc(RqAngle * 10);
  //  CHARSET
  LF.lfCharSet := DEFAULT_CHARSET;
  //    PChar  lfFaceName
  for Ind := 0 to Length(LF.lfFaceName) - 1
  do if Ind + 1 > Length(RqName)
     then Break
     else LF.lfFaceName[Ind] := RqName[Ind + 1];
  //      Windows
  // function CreateFontIndirect; external gdi32 name 'CreateFontIndirectA';
  RqCanvas.Font.Handle := CreateFontIndirect(lf);
end;

//      TextOut
//  TCanvas (    TruType - )
procedure CanvasReSetAngle(RqCanvas : TCanvas;
                           RqAngle : Single);
var  LF : TLOGFONT;     {Font information}
begin
  //   RqCanvas.Font.Handle   LF
  GetObject(RqCanvas.Font.Handle, SizeOf(LF), Addr(LF));
  //      (   )
  LF.lfEscapement  := Trunc(RqAngle * 10);
  LF.lfOrientation := Trunc(RqAngle * 10);
  //      Windows
  // function CreateFontIndirect; external gdi32 name 'CreateFontIndirectA';
  RqCanvas.Font.Handle := CreateFontIndirect(LF);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  Index := 0;
  Randomize;
  Canvas.Font.Name := 'Arial';
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
with Image1
 do begin
   Canvas.Brush.Style := bsSolid;
   Canvas.Brush.Color := Image1.Parent.Brush.Color;
   Canvas.Rectangle(0, 0, Image1.Width, Image1.Height);
   Canvas.TextOut(Image1.Width div 2, Image1.Height div 2, '            ');
   CanvasSetAngle (Canvas, Index, -18, 'Courier New');
   Canvas.TextOut(Image1.Width div 2, Image1.Height div 2, ' ');
   Index := Index + 20;
   if Index >= 360 then
   begin
     Index := 0;
     if ClF
     then Canvas.Font.Color := clBlack
     else Canvas.Font.Color := clRed;
     ClF := not ClF;
   end;
 end;
end;

procedure TForm1.LabelTestMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Ang : integer;
begin
   Ang := Random(3600);
   with LabelTest
   do begin
     CanvasSetAngle (Canvas, Ang / 10, -20, 'Arial');
     Canvas.TextOut(X, Y, FormatFloat('##0.0', Ang / 10 ) + '');
   end;
end;

procedure TForm1.FormClick(Sender: TObject);
var Ang : integer;
    Ind : integer;
begin
    for Ind := 0 to 9
    do begin
      Canvas.Font.Color := Random(65535);
      Ang := Ind * 10;
      CanvasSetAngle (Canvas, Ang, -18, 'Arial');
      Canvas.TextOut(30 + Ind * 70, 120, '');
    end;
end;

end.
